//////////////////////////////////////////////
// ComponentManager.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkWinUiTests.ComponentManager = class ComponentManager extends nkDebug.TestClass
{
	static instance = new ComponentManager ("nkWinUiTests.ComponentManager") ;

	system = null ;

	// Methods
	testEraseCorrectness ()
	{
		// Add some resources
		const resourceCount = 8 ;
		const components = [] ;
		const manager = ComponentManager.instance.system.getComponentManager() ;

		for (let i = 0 ; i < resourceCount ; ++i)
			components.push(manager.createOrRetrieve(i.toString(), nkWinUi.COMPONENT_TYPE.WINDOW)) ;

		// Request to clean
		let counter = 0 ;

		while (manager.getByIndex(0) && counter < resourceCount * 2)
			manager.erase((counter++).toString()) ;

		// Check status sanity
		nkDebug.TestUtils.areNumbersEqual(counter, 8, 0, "Wrong erasure counter") ;

		for (let i = 0 ; i < resourceCount ; ++i)
			nkDebug.TestUtils.isNull(manager.get(i.toString()), "A supposed erased component is not null") ;
	}

	// Common test methods
	nkTests =
	{
		// Management
		__testInit__ : function ()
		{
			// Init nkGraphics
			ComponentManager.instance.system = new nkWinUi.System () ;

			const initResult = ComponentManager.instance.system.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkWinUi, bypassing ComponentManager test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			ComponentManager.instance.system.shutdown()  ;
			ComponentManager.instance.system.delete() ;
			ComponentManager.instance.system = null ;
		},

		// Constructors
		EraseCorrectness : function () {ComponentManager.instance.testEraseCorrectness() ;},
	}
}